'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';
const RESOURCES = {
  "assets/AssetManifest.json": "c1275e61e6f573b0486975260063381d",
"assets/assets/configuration.yaml": "3a26b0de8d10716e07a425d678da084f",
"assets/assets/icons/classcode/ajout.svg": "2bfbdc30696e28429d4a3c4fb622f694",
"assets/assets/icons/classcode/certificat.svg": "1263511bc371aacc90fedaa6fa1c7a3d",
"assets/assets/icons/classcode/directives_anticipees.svg": "c6815b69304102b117091ec261ce2e69",
"assets/assets/icons/classcode/donnees_remboursements.svg": "c056707a7b89d84ec00461bf8126f008",
"assets/assets/icons/classcode/prevention.svg": "3b596ac49e51d2edba3663022b2d8d26",
"assets/assets/icons/classcode/scan-medical.svg": "7341242796f91c4fe0e8e721d931eda8",
"assets/assets/icons/classcode/syntheses.svg": "bc781e0862ffbb7cd4644e17d2b624f1",
"assets/assets/icons/classcode/tous_mes_documents.svg": "71e503af264d6815a696ab0f560f34ff",
"assets/assets/icons/classcode/traitement_prescription.svg": "ac6e61d2e6dc0b2468241a6cfbbddf07",
"assets/assets/icons/classcode/vaccin.svg": "1cc19d0a234e2d427c103405575fd6af",
"assets/assets/icons/icon-brisdeglace.svg": "d44ac0fc33f66c012b9d8b3ce80405dc",
"assets/assets/icons/icon-cadre.svg": "fc00e705d9232d20505a7af0e56ac633",
"assets/assets/icons/icon-classe.svg": "917fd57981bafcced84edcceb4839699",
"assets/assets/icons/icon-dmp-autorise.svg": "4147b8e5956f03446cd977ca7a673a6e",
"assets/assets/icons/icon-dmp-ferme.svg": "78fd4580165bb09e6de057af842abf2b",
"assets/assets/icons/icon-dmp-non-autorise.svg": "8c183f3991a9548f1826354c2927337a",
"assets/assets/icons/icon-dmp-non-cree.svg": "bd7d48157d242bb4daba6063fd62bb39",
"assets/assets/icons/icon-doc.svg": "a7b3124324f0fd0b9e9092ae70871870",
"assets/assets/icons/icon-medecin.svg": "8b44168dee60be0ea769dfc68e99fa50",
"assets/assets/icons/icon-patient.svg": "73f38360cd38f15e20db34234170b444",
"assets/assets/icons/icon-representan.svg": "e7a590ca5cea03f9dbdec5e4d812aa3d",
"assets/assets/icons/icon-shield.svg": "5cfca29b27575ce943f9da0a740a0008",
"assets/assets/icons/icon-structure.svg": "35b33278c3b722849c1a23d94ead6437",
"assets/assets/icons/icon-type.svg": "1c781a11792322531f88abe3bbe20935",
"assets/assets/icons/icon-user.svg": "12b533379a3e133f10f064e8028e0a53",
"assets/assets/icons/icon-visibilite-medecin.svg": "80f2d3353d1c940dde5c7ff8f9be6321",
"assets/assets/icons/icon-visibilite-patient.svg": "ebdc0bc168235c5f85f13281380e7f62",
"assets/assets/icons/icon-visibilite-representant.svg": "8215c14a0eed018c4a0dd7ba542a0e34",
"assets/assets/images/check-documents.png": "4c3f312a5cd5ce254a3878cdd235c04b",
"assets/assets/images/devbox_logo.png": "9e94aa9a8ddb38951d5c846898705762",
"assets/assets/images/dmp_compatible.png": "459f273e0d4637b7bf63f878b2af57a6",
"assets/assets/images/dmp_logo_classique.jpg": "b7253eb31dd33937c6e3efffc416c15e",
"assets/assets/images/dmp_logo_green.png": "b86fe9d159d799969f1bfdd3d862ae0d",
"assets/assets/images/dmp_logo_white.png": "27081480703efdc60f2f64fbc90de3dd",
"assets/assets/images/illu-dashboard-medecin.svg": "152bd13e3d86b9848b518d19a4f5b518",
"assets/assets/images/illu-dashboard-patient.svg": "00f103d6d8c7006950d7324e79154bea",
"assets/assets/images/scan_card.png": "d32cce4c89a4b574e21df8f19619a5cb",
"assets/assets/images/stellair_logo.png": "43b2995508784b3f48d17f7565fb96f7",
"assets/FontManifest.json": "9b0dd16edd7deff4889d158f84bd894e",
"assets/fonts/Lato/Lato-Bold.ttf": "85d339d916479f729938d2911b85bf1f",
"assets/fonts/Lato/Lato-Regular.ttf": "2d36b1a925432bae7f3c53a340868c6e",
"assets/fonts/MaterialIcons-Regular.otf": "95db9098c58fd6db106f1116bae85a0b",
"assets/fonts/roboto/Roboto-Bold.ttf": "9ece5b48963bbc96309220952cda38aa",
"assets/fonts/roboto/Roboto-Regular.ttf": "f36638c2135b71e5a623dca52b611173",
"assets/NOTICES": "8e2f8ffbe029c2b233b519f92f128a8d",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "6d342eb68f170c97609e9da345464e5e",
"assets/shaders/ink_sparkle.frag": "caa1fffb96b357773bc44eabb16f5769",
"canvaskit/canvaskit.js": "2bc454a691c631b07a9307ac4ca47797",
"canvaskit/canvaskit.wasm": "bf50631470eb967688cca13ee181af62",
"canvaskit/profiling/canvaskit.js": "38164e5a72bdad0faa4ce740c9b8e564",
"canvaskit/profiling/canvaskit.wasm": "95a45378b69e77af5ed2bc72b2209b94",
"favicon.png": "5dcef449791fa27946b3d35ad8803796",
"flutter.js": "f85e6fb278b0fd20c349186fb46ae36d",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"icons/Icon-maskable-192.png": "c457ef57daa1d16f64b27b786ec2ea3c",
"icons/Icon-maskable-512.png": "301a7604d45b3e739efc881eb04896ea",
"index.html": "ac200e7ddeae24252a3276119fa0f3e0",
"/": "ac200e7ddeae24252a3276119fa0f3e0",
"main.dart.js": "4540db6da8be1aa6fc3f79e43f4771ec",
"manifest.json": "bb414a3928c9ea2d9fdd1b0185b48203",
"version.json": "639edfac3a0c8c95bac7c1229823c9b3"
};

// The application shell files that are downloaded before a service worker can
// start.
const CORE = [
  "main.dart.js",
"index.html",
"assets/AssetManifest.json",
"assets/FontManifest.json"];
// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});

// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});

// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});

self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});

// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}

// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
