/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.runtime.beans.actions.services.AbstractControlServiceAction;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.DirectOutputRedirection;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class ServiceHandler {
    private static boolean servicesStopped = false;
    private static int systemdVersion = -1;
    public static final int SYSTEMD_VERSION_EXEC_AVAILABLE = 240;
    public static final int SYSTEMD_SYMLINKS_SUPPORTED = 231;

    public static synchronized int getSystemdVersion() {
        if (systemdVersion == -1) {
            systemdVersion = 0;
            File systemctlFile = new File("/bin/systemctl");
            if (systemctlFile.isFile()) {
                LaunchHelper.LaunchResult launchResult = LaunchHelper.launchApplicationWithResult(new LaunchDescriptor(new File("/bin/systemctl")).arguments("--version").wait(true).waitForStreams(true).stdoutRedirection(new DirectOutputRedirection()));
                if (launchResult == null) {
                    Logger.getInstance().error(null, "could not execute systemctl --version");
                } else if (launchResult.getReturnCode() != 0) {
                    Logger.getInstance().error(null, "systemctl --version returned " + launchResult.getReturnCode());
                } else if (launchResult.getOutput() == null) {
                    Logger.getInstance().error(null, "systemctl --version returned no output");
                } else {
                    for (String line : StringUtil.getLines(launchResult.getOutput())) {
                        String trimmed = line.trim();
                        if (!trimmed.startsWith("systemd ")) continue;
                        try {
                            systemdVersion = Integer.parseInt(trimmed.substring(8));
                            break;
                        }
                        catch (NumberFormatException e) {
                            Logger.getInstance().error(null, "version line '" + trimmed + "' unexpected");
                        }
                    }
                    Logger.getInstance().info(null, "systemd version " + systemdVersion);
                }
            }
        }
        return systemdVersion;
    }

    public static void resetStopState() {
        servicesStopped = false;
    }

    public static void stopServices(Context context, boolean force) {
        if (!force && servicesStopped) {
            return;
        }
        if (!InstallerUtil.isWindows()) {
            return;
        }
        ContextInt contextInt = ContextImpl.getContextInt(context);
        List<String> services = contextInt.getInstallationProperties().getPropertyList("service");
        List<String> serviceNames = contextInt.getInstallationProperties().getPropertyList("serviceName");
        if (services.size() > 0 || serviceNames.size() > 0) {
            ProgressInterface progressInterface = context.getProgressInterface();
            progressInterface.setStatusMessage(Messages.getString(".StatusStoppingServices"));
            progressInterface.setDetailMessage(" ");
            progressInterface.setIndeterminateProgress(true);
            context.runElevated(new StopRemoteCallable(services, serviceNames, AbstractControlServiceAction.getMinimumStopTimeout(contextInt)), true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            progressInterface.setIndeterminateProgress(false);
        }
        servicesStopped = true;
    }

    private static class StopRemoteCallable
    extends AbstractRemoteCallable {
        List<String> services;
        List<String> serviceNames;
        final int minimumWaitTime;

        private StopRemoteCallable(List<String> services, List<String> serviceNames, int minimumWaitTime) {
            this.services = services;
            this.serviceNames = serviceNames;
            this.minimumWaitTime = minimumWaitTime;
        }

        @Override
        public Serializable execute() {
            for (String service : this.services) {
                Logger.getInstance().info(ServiceHandler.class, "Stopping service " + service);
                if (!new File(service).exists()) continue;
                try {
                    File systemctlFile;
                    Process process = new ProcessBuilder(service, "/stop").start();
                    process.waitFor();
                    if (Util.isWindows() || Util.isMacOS() || !(systemctlFile = new File("/bin/systemctl")).isFile()) continue;
                    LaunchHelper.launchApplication(new LaunchDescriptor(systemctlFile).arguments("--no-ask-password", "stop", new File(service).getName()).wait(true).executionContext(ExecutionContext.MAXIMUM));
                }
                catch (IOException | InterruptedException e) {
                    Logger.getInstance().log(e);
                }
            }
            for (String serviceName : this.serviceNames) {
                Logger.getInstance().info(ServiceHandler.class, "Stopping service " + serviceName);
                try {
                    Win32Services.stopService(serviceName, this.minimumWaitTime);
                }
                catch (Win32Services.ServiceException e) {
                    if (e.getErrorCode() == 1062 || e.getErrorCode() == 1060) continue;
                    Logger.getInstance().log(e);
                }
            }
            return null;
        }
    }
}

