/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.desktop.MacAssociationRole;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractAssociationAction
extends SystemAutoUninstallInstallAction {
    private static final Map<File, UnixAssociationInfo> executableToUnixAssociationInfo = new HashMap<File, UnixAssociationInfo>();
    private static boolean finderRestarted = false;
    protected static final String PROP_EXECUTABLE = "executable";
    private String launcherId = "";
    private MacAssociationRole macRole = MacAssociationRole.VIEWER;
    private boolean restartFinder = false;

    public String getLauncherId() {
        return AbstractAssociationAction.replaceVariables(this.launcherId);
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public MacAssociationRole getMacRole() {
        return this.replaceWithTextOverride("macRole", this.macRole, MacAssociationRole.class);
    }

    public void setMacRole(MacAssociationRole macAssociationRole) {
        this.macRole = macAssociationRole;
    }

    @Override
    public void rollback(InstallerContext context) {
        super.rollback(context);
        if (InstallerUtil.isWindows()) {
            Registry.changeNotifyAssociations();
        }
    }

    protected File getExecutableFile(Context context) {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        LauncherConfig launcher = config.getLauncherConfigById(this.getLauncherId());
        if (launcher == null) {
            return null;
        }
        return context.getDestinationFile(launcher.getFile());
    }

    protected static void refresh(final File bundleDir, final boolean restartFinder) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                AbstractAssociationAction.doRefresh(bundleDir, restartFinder);
            }
        });
    }

    private static void doRefresh(File bundleDir, boolean restartFinder) {
        MacFileSystem.notifyBundleChange(bundleDir);
        try {
            String[] command = new String[]{"/System/Library/Frameworks/ApplicationServices.framework/Frameworks/LaunchServices.framework/Support/lsregister", "-R", "-f", bundleDir.getAbsolutePath()};
            if (!new File(command[0]).exists()) {
                command[0] = "/System/Library/Frameworks/CoreServices.framework/Frameworks/LaunchServices.framework/Support/lsregister";
            }
            if (!Execution.executeAndWait(command, null)) {
                Util.logError(null, "refresh db not successful");
            }
        }
        catch (IOException e) {
            Util.logError(null, "could not refresh db: " + e.getMessage());
        }
        if (restartFinder && !finderRestarted) {
            finderRestarted = true;
            Runtime.getRuntime().addShutdownHook(new Thread("finder restart"){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec("killall -SIGHUP Finder");
                    }
                    catch (IOException e) {
                        System.err.println("could not restart finder: " + e.getMessage());
                    }
                }
            });
        }
    }

    protected static boolean insertMacAssociation(File infoPlistFile, File icon, String insertionPoint, String typeName, InsertFunction insertFunction) throws IOException {
        if (icon != null) {
            File resourceFile = new File(new File(infoPlistFile.getParentFile(), "Resources"), icon.getName());
            FileUtil.copyFile(icon, resourceFile);
            FileInstaller.getInstance().registerUninstallFile(resourceFile);
        }
        File tempFile = new File(infoPlistFile.getAbsolutePath() + ".temp");
        tempFile.delete();
        infoPlistFile.renameTo(tempFile);
        boolean inserted = false;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), StandardCharsets.UTF_8));
             PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlistFile), StandardCharsets.UTF_8));){
            String line = bufferedReader.readLine();
            boolean entryFound = false;
            String bundleIdentifier = null;
            while (line != null) {
                pw.println(line);
                String nextLine = bufferedReader.readLine();
                if (!inserted) {
                    if (line.contains("<key>CFBundleIdentifier</key>") && nextLine != null && nextLine.contains("<string>")) {
                        int startIndex = nextLine.indexOf("<string>");
                        int endIndex = nextLine.indexOf("</string>");
                        if (endIndex > -1 && startIndex > -1) {
                            bundleIdentifier = nextLine.substring(startIndex + "<string>".length(), endIndex);
                        }
                    } else if (line.contains(typeName)) {
                        entryFound = true;
                    } else if (entryFound && line.contains("<array>")) {
                        insertFunction.insert(pw, bundleIdentifier);
                        inserted = true;
                    } else if (line.contains(insertionPoint) && (nextLine == null || !nextLine.contains(typeName))) {
                        pw.println("<key>" + typeName + "</key>");
                        pw.println("<array>");
                        insertFunction.insert(pw, bundleIdentifier);
                        pw.println("</array>");
                        inserted = true;
                    }
                }
                line = nextLine;
            }
        }
        tempFile.delete();
        return inserted;
    }

    protected static File getBundleDir(Context context, String launcherId) {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        File bundleDir = null;
        if (config.getMacSpecificConfig().isSingleBundle()) {
            bundleDir = context.getDestinationFile(config.getMacSpecificConfig().getSingleBundleName());
        } else {
            LauncherConfig launcher = config.getLauncherConfigById(launcherId);
            if (launcher != null) {
                bundleDir = context.getDestinationFile(launcher.getFile());
            }
        }
        return bundleDir;
    }

    protected static boolean addMimeTypeToDesktopFile(File desktopFile, String mimeType) throws IOException {
        String[] lines = FileUtil.readTextFile(desktopFile, "UTF-8").split("\\r?\\n");
        boolean found = false;
        int execLine = -1;
        for (int i = 0; i < lines.length && !found; ++i) {
            if (lines[i].startsWith("MimeType=")) {
                if (lines[i].contains(mimeType)) continue;
                if (!lines[i].endsWith(";")) {
                    int n = i;
                    lines[n] = lines[n] + ";";
                }
                int n = i;
                lines[n] = lines[n] + mimeType + ";";
                found = true;
                continue;
            }
            if (execLine != -1 || !lines[i].startsWith("Exec=")) continue;
            execLine = i;
        }
        if (!found) {
            if (execLine == -1) {
                Logger.getInstance().error(null, "did not find Exec entry in " + desktopFile);
                return false;
            }
            ArrayList<String> newLines = new ArrayList<String>(Arrays.asList(lines));
            newLines.add(execLine + 1, "MimeType=" + mimeType + ";");
            lines = newLines.toArray(new String[0]);
        }
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(desktopFile), StandardCharsets.UTF_8));){
            for (String line : lines) {
                pw.println(line);
            }
        }
        MenuHelper.installDesktopFile(desktopFile);
        MenuHelper.execute("xdg-mime", "default", desktopFile.getName(), mimeType);
        return true;
    }

    public boolean isUsedForStaticAssociation(String launcherId) {
        return Objects.equals(launcherId, this.getLauncherId());
    }

    public static void registerDesktopFile(File executableFile, File desktopFile) throws IOException, UserCanceledException {
        AbstractAssociationAction.getUnixAssociationInfo(executableFile).registerDesktopFile(desktopFile);
    }

    protected static UnixAssociationInfo getUnixAssociationInfo(File executableFile) {
        UnixAssociationInfo ret = executableToUnixAssociationInfo.get(executableFile = FileUtil.getCanonicalFile(executableFile));
        if (ret == null) {
            ret = new UnixAssociationInfo();
            executableToUnixAssociationInfo.put(executableFile, ret);
        }
        return ret;
    }

    protected static interface DesktopFileHandler {
        public void handle(File var1) throws IOException, UserCanceledException;
    }

    protected static interface InsertFunction {
        public void insert(PrintWriter var1, String var2);
    }

    static class UnixAssociationInfo {
        private final Set<File> desktopFiles = new HashSet<File>();
        private final Map<AbstractAssociationAction, DesktopFileHandler> actions = new IdentityHashMap<AbstractAssociationAction, DesktopFileHandler>();

        UnixAssociationInfo() {
        }

        public void registerDesktopFile(File desktopFile) throws IOException, UserCanceledException {
            for (DesktopFileHandler desktopFileHandler : this.actions.values()) {
                desktopFileHandler.handle(desktopFile);
            }
            this.desktopFiles.add(desktopFile);
        }

        public void addAction(AbstractAssociationAction associationAction, DesktopFileHandler desktopFileHandler) {
            this.actions.put(associationAction, desktopFileHandler);
        }

        public Set<File> getDesktopFiles() {
            return this.desktopFiles;
        }
    }
}

