/*
 * Decompiled with CFR 0.152.
 */
package fr.devboxsante.clients.installation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PropertiesConfiguration {
    private static final String WIN_API_PATH = "\\santesocial\\api_lec\\";
    private static final String WIN_CPS_PATH = "\\santesocial\\cps\\";
    private static final String MAC_API_PATH = "/santesocial/api_lec/";
    private static final String MAC_CPS_PATH = "/santesocial/cps/";
    private static final String osname = System.getProperty("os.name");

    public static void main(String ... args) {
        try {
            Path currentRelativePath = Paths.get("", new String[0]);
            String rootPath = currentRelativePath.toAbsolutePath().toString();
            Path source = Paths.get(rootPath + "/application.yml", new String[0]);
            Charset charset = StandardCharsets.UTF_8;
            String content = new String(Files.readAllBytes(source), charset);
            if (args != null && args.length > 0) {
                content = content.replace("${eureka.url:}", "http://localhost:" + args[0]);
                System.out.println("INFO eureka url: http://localhost:" + args[0]);
            }
            content = content.replace("${vitale.libFilePath:}", rootPath + PropertiesConfiguration.getApiLecLibName());
            content = content.replace("${vitale.iniFilePath:}", rootPath + PropertiesConfiguration.getApiLecIniName());
            content = content.replace("${cps.module.path:}", rootPath + PropertiesConfiguration.getCpsLibName());
            Files.write(source, content.getBytes(charset), new OpenOption[0]);
            System.out.println("INFO : libFilePath " + rootPath + PropertiesConfiguration.getApiLecLibName());
            System.out.println("INFO : iniFilePath " + rootPath + PropertiesConfiguration.getApiLecIniName());
            System.out.println("INFO : cpsPath " + rootPath + PropertiesConfiguration.getCpsLibName());
            System.out.println("INFO : application yaml updated");
            System.out.print("true");
        }
        catch (IOException ex) {
            System.err.println("ERROR : " + ex.getMessage());
            ex.printStackTrace(System.err);
            System.out.print("false");
        }
        System.exit(0);
    }

    private static String getApiLecLibName() {
        if (PropertiesConfiguration.isWindows()) {
            if (PropertiesConfiguration.isX86Architecture()) {
                return "\\santesocial\\api_lec\\api_lec.dll";
            }
            return "\\santesocial\\api_lec\\api_lec64.dll";
        }
        if (PropertiesConfiguration.isMac()) {
            return "/santesocial/api_lec/libapi_lec.dylib";
        }
        if (PropertiesConfiguration.isX86Architecture()) {
            return "/santesocial/api_lec/libapileclux.so";
        }
        return "/santesocial/api_lec/libapileclux64.so";
    }

    private static String getApiLecIniName() {
        if (PropertiesConfiguration.isWindows()) {
            return "\\santesocial\\api_lec\\api_lec.ini";
        }
        return "/santesocial/api_lec/api_lec.ini";
    }

    private static String getCpsLibName() {
        if (PropertiesConfiguration.isWindows()) {
            if (PropertiesConfiguration.isX86Architecture()) {
                return "\\santesocial\\cps\\cps3_pkcs11_w32.dll";
            }
            return "\\santesocial\\cps\\cps3_pkcs11_w64.dll";
        }
        if (PropertiesConfiguration.isMac()) {
            return "/santesocial/cps/libcps3_pkcs11_osx.dylib";
        }
        return "/santesocial/cps/libcps_pkcs11_lux.so";
    }

    public static String name() {
        return osname;
    }

    public static boolean isLinux() {
        return osname.toLowerCase().contains("linux");
    }

    public static boolean isMac() {
        return osname.toLowerCase().contains("mac");
    }

    public static boolean isWindows() {
        return osname.toLowerCase().startsWith("windows");
    }

    public static boolean isX86Architecture() {
        return System.getProperty("sun.arch.data.model").equals("32");
    }
}

