/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String VARIABLE_START = "${";
    public static final String VARIABLE_END = "}";
    private static final String ELVIS = "?:";

    private StringUtil() {
    }

    public static String rtrim(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && Character.isWhitespace(string.charAt(i)); --i) {
        }
        return string.substring(0, i + 1);
    }

    public static String repeat(String string, int count) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buffer.append(string);
        }
        return buffer.toString();
    }

    public static String replace(String string, String pattern, String replace) {
        int endIndex;
        int startIndex = 0;
        StringBuilder result = new StringBuilder();
        while ((endIndex = string.indexOf(pattern, startIndex)) >= 0) {
            result.append(string, startIndex, endIndex);
            result.append(replace);
            startIndex = endIndex + pattern.length();
        }
        result.append(string.substring(startIndex));
        return result.toString();
    }

    public static String replaceVariable(String string, ReplacementCallback replacementCallback) {
        return StringUtil.replaceVariable(string, VARIABLE_START, VARIABLE_END, replacementCallback);
    }

    public static String replaceVariable(String string, String startPattern, String endPattern, ReplacementCallback replacementCallback) {
        return StringUtil.replaceVariable(string, startPattern, endPattern, replacementCallback, null);
    }

    public static String replaceVariable(String string, ReplacementCallback replacementCallback, Object memento) {
        return StringUtil.replaceVariable(string, VARIABLE_START, VARIABLE_END, replacementCallback, memento);
    }

    public static String replaceVariable(String string, String startPattern, String endPattern, ReplacementCallback replacementCallback, Object memento) {
        int endIndex;
        int variableIndex;
        int startIndex = 0;
        StringBuilder result = new StringBuilder();
        while ((variableIndex = string.indexOf(startPattern, startIndex)) >= 0 && (endIndex = StringUtil.getEndIndex(string, startPattern, endPattern, variableIndex)) >= 0) {
            String fallback;
            String variable;
            int nextVariableIndex = string.indexOf(startPattern, variableIndex + startPattern.length());
            int nextElvisIndex = string.indexOf(ELVIS, variableIndex + startPattern.length());
            if (nextVariableIndex > -1 && nextVariableIndex < endIndex && (nextElvisIndex == -1 || nextElvisIndex > endIndex || nextElvisIndex > nextVariableIndex)) {
                result.append(string, startIndex, nextVariableIndex);
                startIndex = nextVariableIndex;
                continue;
            }
            String variableWithElvis = string.substring(variableIndex + startPattern.length(), endIndex);
            int elvisIndex = variableWithElvis.indexOf(ELVIS);
            if (elvisIndex > 0) {
                variable = variableWithElvis.substring(0, elvisIndex);
                boolean skipReplacement = replacementCallback instanceof SkippableReplacementCallback && ((SkippableReplacementCallback)replacementCallback).isSkipReplacement(variable);
                fallback = skipReplacement ? null : variableWithElvis.substring(elvisIndex + ELVIS.length());
            } else {
                variable = variableWithElvis;
                fallback = null;
            }
            String replacement = replacementCallback.getReplacement(variable, memento, fallback != null);
            if (replacement == null && fallback == null) {
                result.append(string, startIndex, endIndex + endPattern.length());
            } else {
                result.append(string, startIndex, variableIndex);
                result.append(replacement != null ? replacement : fallback);
            }
            startIndex = endIndex + endPattern.length();
        }
        result.append(string.substring(startIndex));
        String resultString = result.toString();
        if (!string.equals(resultString) && resultString.contains(startPattern)) {
            return StringUtil.replaceVariable(resultString, startPattern, endPattern, replacementCallback, memento);
        }
        return resultString;
    }

    public static int getEndIndex(String string, String startPattern, String endPattern, int startIndex) {
        int firstEndIndex = string.indexOf(endPattern, startIndex + startPattern.length());
        int elvisIndex = string.indexOf(ELVIS, startIndex + startPattern.length());
        if (elvisIndex > -1 && elvisIndex < firstEndIndex) {
            int balancedEndIndex = StringUtil.findBalancedEndIndex(string, startPattern, endPattern, elvisIndex + ELVIS.length());
            if (balancedEndIndex > 0) {
                return balancedEndIndex;
            }
            return firstEndIndex;
        }
        return firstEndIndex;
    }

    private static int findBalancedEndIndex(String string, String startPattern, String endPattern, int startIndex) {
        int openCount = 0;
        while (true) {
            int startPatternIndex = string.indexOf(startPattern, startIndex);
            int endPatternIndex = string.indexOf(endPattern, startIndex);
            if (endPatternIndex == -1) {
                return -1;
            }
            if (endPatternIndex < startPatternIndex || startPatternIndex == -1) {
                if (openCount == 0) {
                    return endPatternIndex;
                }
                --openCount;
                startIndex = endPatternIndex + endPattern.length();
                continue;
            }
            ++openCount;
            startIndex = startPatternIndex + startPattern.length();
        }
    }

    public static void splitupCommandLine(List<String> cmdList, String command) {
        StringUtil.splitupQuotedList(cmdList, command, " ");
    }

    public static void splitupQuotedList(List<String> list, String line, String delimiter) {
        if (line != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, delimiter + "\"", true);
            boolean insideQuotes = false;
            StringBuilder argument = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\"")) {
                    if (insideQuotes && argument.length() > 0) {
                        list.add(argument.toString());
                        argument.setLength(0);
                    }
                    insideQuotes = !insideQuotes;
                    continue;
                }
                if (delimiter.contains(token)) {
                    if (insideQuotes) {
                        argument.append(delimiter);
                        continue;
                    }
                    if (argument.length() <= 0) continue;
                    list.add(argument.toString());
                    argument.setLength(0);
                    continue;
                }
                argument.append(token);
            }
            if (argument.length() > 0) {
                list.add(argument.toString());
            }
        }
    }

    public static String trimLineSeparators(String text) {
        return StringUtil.trimPattern(StringUtil.trimPattern(text, "\n"), "\r\n");
    }

    private static String trimPattern(String text, String pattern) {
        if (text.length() < pattern.length()) {
            return text;
        }
        int firstPosition = 0;
        int patternLength = pattern.length();
        while (text.substring(firstPosition, firstPosition + patternLength).equals(pattern)) {
            firstPosition += patternLength;
        }
        int lastPosition = text.length();
        if (firstPosition + patternLength == lastPosition) {
            return "";
        }
        while (text.substring(lastPosition - patternLength, lastPosition).equals(pattern)) {
            lastPosition -= patternLength;
        }
        return text.substring(firstPosition, lastPosition);
    }

    public static String padLeft(String val, char padChar, int length) {
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length - val.length(); ++i) {
            buffer.append(padChar);
        }
        buffer.append(val, 0, Math.min(length, val.length()));
        return buffer.toString();
    }

    public static String padRight(String val, char padChar, int length) {
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(val, 0, Math.min(length, val.length()));
        for (int i = 0; i < length - val.length(); ++i) {
            buffer.append(padChar);
        }
        return buffer.toString();
    }

    public static String makeCommandLine(String[] commands) {
        if (commands == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String command : commands) {
            buffer.append('\"');
            buffer.append(command);
            buffer.append('\"');
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String toStringWithArrays(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Class<?> c = object.getClass();
            if (c == byte[].class) {
                return Arrays.toString((byte[])object);
            }
            if (c == short[].class) {
                return Arrays.toString((short[])object);
            }
            if (c == int[].class) {
                return Arrays.toString((int[])object);
            }
            if (c == long[].class) {
                return Arrays.toString((long[])object);
            }
            if (c == char[].class) {
                return Arrays.toString((char[])object);
            }
            if (c == float[].class) {
                return Arrays.toString((float[])object);
            }
            if (c == double[].class) {
                return Arrays.toString((double[])object);
            }
            if (c == boolean[].class) {
                return Arrays.toString((boolean[])object);
            }
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }

    public static List<String> getLines(String text) {
        ArrayList<String> ret = new ArrayList<String>();
        if (text != null) {
            BufferedReader stringReader = new BufferedReader(new StringReader(text));
            try {
                String line = stringReader.readLine();
                while (line != null) {
                    ret.add(line);
                    line = stringReader.readLine();
                }
                stringReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static int countNonOverlappingSubstrings(String containedText, String text) {
        return text.split(Pattern.quote(containedText), -1).length - 1;
    }

    public static interface ReplacementCallback {
        public String getReplacement(String var1, Object var2, boolean var3);
    }

    public static interface SkippableReplacementCallback
    extends ReplacementCallback {
        public boolean isSkipReplacement(String var1);
    }
}

