/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MsiScope;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MsiHelper {
    public static final String MSI_KEY = "SOFTWARE\\ej-technologies\\install4j\\msiwrapper";
    private static final String PROP_NAME_MSI_FILE = "install4j.msiFile";
    private static final String MSI_FILE = System.getProperty("install4j.msiFile");
    private static volatile boolean msiAllUsers = Boolean.getBoolean("install4j.msiAllUsers") || HelperCommunication.getInstance().isElevatedHelper();

    public static void writeMsiUninstaller(Context context) {
        if (Util.isWindowsInstaller() && !InstallerConfig.getCurrentInstance().isAddOnInstaller() && MsiHelper.isStartedFromMsi()) {
            final String uninstallerPath = MsiHelper.getUninstallerPath(context);
            final String productId = MsiHelper.getMsiProductId();
            if (productId != null && new File(uninstallerPath).isFile()) {
                HelperCommunication helperCommunication = HelperCommunication.getInstance();
                if (MsiHelper.isMsiAllUsers(context) && (Util.hasFullAdminRights() || helperCommunication.hasElevatedHelper())) {
                    helperCommunication.executeAction(ExecutionContext.MAXIMUM, new RunAction(){

                        @Override
                        protected void run(Context context) {
                            if (!WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, MsiHelper.MSI_KEY, productId, uninstallerPath, RegistryView.BIT64)) {
                                WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, MsiHelper.MSI_KEY, productId, uninstallerPath, RegistryView.BIT64);
                            }
                        }
                    });
                } else {
                    WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, MSI_KEY, productId, uninstallerPath, RegistryView.BIT64);
                }
            }
        }
    }

    @NotNull
    private static String getUninstallerPath(Context context) {
        return FileUtil.getCanonicalPath(new File(context.getInstallationDirectory(), InstallerConfig.getCurrentInstance().getUninstallerPath() + ".exe"));
    }

    public static void removeMsiUninstaller(Context context) {
        final String uninstallerPath = MsiHelper.getUninstallerPath(context);
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                MsiHelper.removeMsiUninstaller(uninstallerPath, RegistryRoot.HKEY_LOCAL_MACHINE);
                MsiHelper.removeMsiUninstaller(uninstallerPath, RegistryRoot.HKEY_CURRENT_USER);
            }
        });
    }

    private static void removeMsiUninstaller(String uninstallerPath, RegistryRoot registryRoot) {
        String[] valueNames = WinRegistry.getValueNames(registryRoot, MSI_KEY, RegistryView.BIT32);
        if (valueNames != null) {
            for (String valueName : valueNames) {
                Object otherUninstaller = WinRegistry.getValue(registryRoot, MSI_KEY, valueName, RegistryView.BIT32);
                if (!Objects.equals(otherUninstaller, uninstallerPath)) continue;
                WinRegistry.deleteValue(registryRoot, MSI_KEY, valueName, RegistryView.BIT32);
            }
        }
    }

    public static boolean isMsiStartMsimatch() {
        return MsiHelper.isBuildForMsi() && !MsiHelper.isStartedFromMsi();
    }

    public static boolean isStartedFromMsi() {
        return MSI_FILE != null;
    }

    private static boolean isBuildForMsi() {
        return MsiHelper.getMsiProductId() != null;
    }

    public static String getMsiFile() {
        return MSI_FILE;
    }

    public static String getMsiProductId() {
        String productId = InstallerConfig.getCurrentInstance().getCompilerVariables().get("sys.msiProductId");
        if (productId == null || productId.isEmpty()) {
            return null;
        }
        return productId;
    }

    public static boolean isMsiAllUsers(Context context) {
        if (InstallerConfig.isInstaller()) {
            return msiAllUsers;
        }
        return ContextImpl.getContextInt(context).getInstallationProperties().isMsiAllUsers();
    }

    public static void setMsiAllUsers(boolean msiAllUsers) {
        if (MsiHelper.getMsiScope() != MsiScope.PER_USER) {
            MsiHelper.msiAllUsers = msiAllUsers;
        }
    }

    public static void addMsiVariables(final Context context) {
        InstallerVariables.registerVariableProvider("sys.msiAllUsers", new InstallerVariables.ReadOnlyVariableProvider(){

            @Override
            public Object getVariable() {
                return MsiHelper.isMsiAllUsers(context);
            }
        });
    }

    public static MsiScope getMsiScope() {
        return InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().getMsiScope();
    }

    public static String addMsiArguments(String arguments) {
        return arguments + " \"-D" + PROP_NAME_MSI_FILE + "=" + MsiHelper.getMsiFile() + "\"";
    }
}

