/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.AbstractInstallFilesAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.misc.VariableSelectionMode;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class InstallFilesAction
extends AbstractInstallFilesAction {
    private static InstallFilesAction firstExecutedAction = null;
    private boolean installRuntime = true;
    private boolean updateBundledJre = true;
    private boolean validateApplicationId = false;
    private boolean checkFreeSpace = true;
    private ScriptProperty sizeCalculatorScript;
    private boolean saveDownloadedFiles = false;

    public ScriptProperty getSizeCalculatorScript() {
        return this.replaceWithTextOverride("sizeCalculatorScript", this.sizeCalculatorScript, ScriptProperty.class);
    }

    public void setSizeCalculatorScript(ScriptProperty sizeCalculatorScript) {
        this.sizeCalculatorScript = sizeCalculatorScript;
    }

    public boolean isSaveDownloadedFiles() {
        return this.replaceWithTextOverride("saveDownloadedFiles", this.saveDownloadedFiles);
    }

    public void setSaveDownloadedFiles(boolean saveDownloadedFiles) {
        this.saveDownloadedFiles = saveDownloadedFiles;
    }

    public boolean isInstallRuntime() {
        return this.replaceWithTextOverride("installRuntime", this.installRuntime);
    }

    public void setInstallRuntime(boolean installRuntime) {
        this.installRuntime = installRuntime;
    }

    public boolean isUpdateBundledJre() {
        return this.replaceWithTextOverride("updateBundledJre", this.updateBundledJre);
    }

    public void setUpdateBundledJre(boolean updateBundledJre) {
        this.updateBundledJre = updateBundledJre;
    }

    public boolean isValidateApplicationId() {
        return this.replaceWithTextOverride("validateApplicationId", this.validateApplicationId);
    }

    public void setValidateApplicationId(boolean validateApplicationId) {
        this.validateApplicationId = validateApplicationId;
    }

    public boolean isCheckFreeSpace() {
        return this.replaceWithTextOverride("checkFreeSpace", this.checkFreeSpace);
    }

    public void setCheckFreeSpace(boolean checkFreeSpace) {
        this.checkFreeSpace = checkFreeSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (firstExecutedAction != this && firstExecutedAction != null) {
            Logger.getInstance().info(this, "Another install files action has already run.");
            return true;
        }
        firstExecutedAction = this;
        this.log();
        ProgressInterface progressInterface = this.getProgressInterface(context);
        File validationDir = ContentInstaller.validateInstallationDir(context.getInstallationDirectory(), this.isValidateApplicationId(), this.isCheckFreeSpace(), false, context.isUnattended(), true);
        if (validationDir == null) {
            throw new UserCanceledException();
        }
        context.setInstallationDirectory(validationDir);
        if (!Boolean.getBoolean("install4j.keepServicesRunning")) {
            ServiceHandler.stopServices(context, false);
        }
        if (this.isInstallRuntime() && !RunningProcessChecker.checkDefaultRunningLauncher()) {
            throw new UserCanceledException();
        }
        try {
            FileInstaller.getInstance().setLogDir(context.getDestinationFile(".install4j"));
            FileInstaller.getInstance().resetCurrentRebootRequired();
            try {
                ContentInstaller.getInstance().doStandardInstallation(context, progressInterface, this);
            }
            catch (ReadIOException e) {
                Logger.getInstance().error(this, "content corrupted.");
                Logger.getInstance().log(e.getCause());
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.isTriggerReboot() && this.isDelay() && FileInstaller.getInstance().isCurrentRebootRequired()) {
                    context.triggerReboot(true);
                }
            }
            this.writeResponseFile(context);
            if (context.isCancelling()) {
                throw new UserCanceledException();
            }
        }
        catch (IOException e) {
            context.handleCriticalException(e);
            return false;
        }
        progressInterface.setDetailMessage("");
        return true;
    }

    @Override
    public void rollback(InstallerContext context) {
        super.rollback(context);
        ContentInstaller.getInstance().rollback();
    }

    public void writeResponseFile(InstallerContext context) throws IOException, UserCanceledException {
        File runtimeDirectory = ContextImpl.getContextInt(context).getRuntimeDirectory();
        if (runtimeDirectory.exists() && InstallerConfig.isInstaller() && !Boolean.getBoolean("install4j.dontStoreInstallationLog")) {
            String suffix = "";
            if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
                suffix = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
            }
            File responseFile = new File(runtimeDirectory, "response.varfile" + suffix);
            BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(responseFile, false);
            backupAction.install(context);
            this.addRollbackAction(backupAction);
            FileOutputStream out = new FileOutputStream(responseFile);
            out.write(InstallerVariables.getResponseFileContent(VariableSelectionMode.EXCLUDE, null));
            out.close();
            FileInstaller.getInstance().registerUninstallFile(responseFile);
        }
    }

    private void log() {
        List<ComponentConfig> components = InstallerConfig.getCurrentInstance().getComponents();
        for (ComponentConfig componentConfig : components) {
            Logger.getInstance().info(this, "Component " + componentConfig);
        }
    }

    public static boolean hasRun() {
        return firstExecutedAction != null;
    }
}

